/*global define*/
/*jslint white: true */

/*
	This class provides the an event handler to zoom and scroll a view.
*/


define ([	"src/math/Vec2", "src/math/Mat3"],
function(	vec2, Mat3) {
	'use strict';

	function MouseViewEventHandler(inContainer) {
		var that = this, lastDownPt, p, middleDownB = false, mtx, invMtx, scale, lastEventPos;

		if (inContainer === undefined) {
			throw new TypeError("Undefined container passed to MouseViewEventHandler.");
		}
		that.mouseEventHandler = function (event) {
			var handledB = false, pos = event.position.slice(0), pos2;

			lastEventPos = lastEventPos || event.position.slice(0);
			if (pos !== undefined) {
				invMtx = Mat3.invert(inContainer.getMatrixRelativeTo(null));
				vec2.transformAffine(invMtx, pos, pos);
			}
			if (event.type === "down") {
				if (event.button === "middle") {
					middleDownB = true;
					lastDownPt = pos;
					handledB = true;
				}
			} else if (event.type === "up") {
				if (middleDownB) {
					middleDownB = false;
					handledB = true;
				}
			} else if (event.type === "out") {
				lastDownPt = undefined;
				handledB = true;
			} else if (event.type === "wheel" && event.wheelDelta !== undefined) {
				mtx = inContainer.getMatrix();
				scale = (event.wheelDelta[0] || event.wheelDelta[1]) * 0.25 + 1;
				if (scale < 0) {
					scale = -1 / scale;
				}
				if (scale) {
					mtx = mtx.prescale([scale, scale]);
					pos2 = vec2.transformAffine(mtx, pos);
					pos = event.position;
					mtx = mtx.pretranslate(vec2.subtract(pos, pos2));
					inContainer.setMatrix(mtx);
					handledB = true;
				}
			} else if (event.type === "move") {
				if (middleDownB) {
					mtx = inContainer.getMatrix();
					inContainer.setMatrix(mtx.pretranslate(vec2.subtract(event.position, lastEventPos[0])));
					handledB = true;
				}
			}
			lastEventPos = event.position.slice(0);
			return handledB;
		};

		return that;
	}

	return function mouseViewEventHandler(inView, inContainer) {
		var eventHandler = new MouseViewEventHandler(inContainer);
		inView.installMouseEventHandler(eventHandler.mouseEventHandler);
	};
});
